/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.data.mapping;

import dev.quantumfusion.dashloader.DashDataManager;
import dev.quantumfusion.dashloader.DashLoader;
import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.data.DashIdentifierInterface;
import dev.quantumfusion.dashloader.data.common.IntIntList;
import dev.quantumfusion.dashloader.data.model.DashModel;
import dev.quantumfusion.dashloader.fallback.model.DashMissingDashModel;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.registry.chunk.write.AbstractWriteChunk;
import dev.quantumfusion.taski.Task;
import dev.quantumfusion.taski.builtin.StepTask;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;

public class DashModelData
implements Dashable<Map<class_2960, class_1087>> {
    public final IntIntList models;

    public DashModelData(IntIntList models) {
        this.models = models;
    }

    public DashModelData(DashDataManager data, RegistryWriter writer, StepTask parent) {
        DashDataManager.DashWriteContextData writeContextData = data.getWriteContextData();
        Object2ObjectMap<class_1087, DashMissingDashModel> missingModelsWrite = writeContextData.missingModelsWrite;
        Map<class_2960, class_1087> models = data.bakedModels.getMinecraftData();
        this.models = new IntIntList(new ArrayList<IntIntList.IntInt>(models.size()));
        parent.run((Task)new StepTask("Models", models.size()), task -> {
            AbstractWriteChunk modelChunk = writer.getChunk(DashModel.class);
            AbstractWriteChunk identifierChunk = writer.getChunk(DashIdentifierInterface.class);
            models.forEach((identifier, bakedModel) -> {
                if (bakedModel != null) {
                    int add = writer.addDirect(modelChunk, bakedModel);
                    if (!missingModelsWrite.containsKey(bakedModel)) {
                        this.models.put(writer.addDirect(identifierChunk, identifier), add);
                    }
                }
                task.next();
            });
        });
    }

    @Override
    public Map<class_2960, class_1087> export(RegistryReader reader) {
        HashMap<class_2960, class_1087> out = new HashMap<class_2960, class_1087>();
        this.models.forEach((key, value) -> out.put((class_2960)reader.get(key), (class_1087)reader.get(value)));
        Object2ObjectMap<class_2680, class_2960> missingModelsRead = DashLoader.DL.getData().getReadContextData().missingModelsRead;
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        DashLoader.LOG.info("Scanning Blocks");
        for (class_2248 block : class_2378.field_11146) {
            tasks.add(() -> block.method_9595().method_11662().forEach(blockState -> {
                class_1091 modelId = class_773.method_3340((class_2680)blockState);
                if (!out.containsKey(modelId)) {
                    missingModelsRead.put(blockState, (Object)modelId);
                }
            }));
        }
        DashLoader.LOG.info("Verifying {} BlockStates", (Object)tasks.size());
        DashLoader.DL.thread.parallelRunnable(tasks);
        DashLoader.LOG.info("Found {} Missing BlockState Models", (Object)missingModelsRead.size());
        return out;
    }
}

